;(function($) {
  (function(pluginName) {
    var defaults = {
      inputField: 'input.keypad',
      buttonTemplate: '<button></button>',
      submitButtonText: 'ok',
      deleteButtonText: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -32 576 576" width="1em" height="1em" fill="currentColor">
    <!--! Font Awesome Free 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
    <path d="M576 384C576 419.3 547.3 448 512 448H205.3C188.3 448 172 441.3 160 429.3L9.372 278.6C3.371 272.6 0 264.5 0 256C0 247.5 3.372 239.4 9.372 233.4L160 82.75C172 70.74 188.3 64 205.3 64H512C547.3 64 576 92.65 576 128V384zM271 208.1L318.1 256L271 303C261.7 312.4 261.7 327.6 271 336.1C280.4 346.3 295.6 346.3 304.1 336.1L352 289.9L399 336.1C408.4 346.3 423.6 346.3 432.1 336.1C442.3 327.6 442.3 312.4 432.1 303L385.9 256L432.1 208.1C442.3 199.6 442.3 184.4 432.1 175C423.6 165.7 408.4 165.7 399 175L352 222.1L304.1 175C295.6 165.7 280.4 165.7 271 175C261.7 184.4 261.7 199.6 271 208.1V208.1z"></path>
</svg>`,
      submitButtonClass: 'submit',
      deleteButtonClass: 'delete'
    };
    $.fn[pluginName] = function(options) {
      options = $.extend(true, {}, defaults, options);
            
      return this.each(function() {
        var elem = this,
          $elem = $(elem),
          $input = jQuery.type(options.inputField) == 'string' ? $(options.inputField) : options.inputField,
          $form = $input.parents('form').length ? $($input.parents('form')[0]) : $elem;

        var numbers = Array.apply(null, Array(9)).map(function (_, i) {
          return $(options.buttonTemplate).html(i+1).addClass('number');
        });

        numbers.push($(options.buttonTemplate).html("").addClass('number'));
        numbers.push($(options.buttonTemplate).html("0").addClass('number'));
        numbers.push($(options.buttonTemplate).html(options.deleteButtonText).addClass(options.deleteButtonClass));

        $elem.html(numbers).addClass('keypad');

        $elem.find('.number').click(function(e) {
          let targ =  $(e.target).text();
          if($input.val().length<4 && targ!='') {
            let newText = $input.val() + targ;
            var newTextLength = newText.length;
            console.log(newTextLength);
            var counter=0;
            $('.circle').each(function (k,v){
              if(counter<newTextLength) {
                $(v).removeClass('fa-circle-thin');
                $(v).addClass('fa-circle');
              }else{
                $(v).removeClass('fa-circle');
                $(v).addClass('fa-circle-thin');
              }
              counter++;
            });
            $input.val(newText);
            if(newTextLength==4){
              $('form').trigger('submit');
            }
            $input.trigger('change');
          }
        });
        $elem.find('.' + options.deleteButtonClass).click(function(e) {
          let newText =$input.val().slice(0, -1);
          var newTextLength = newText.length;
          $input.val(newText);

          var counter=0;
          $('.circle').each(function (k,v){
            if(counter<newTextLength) {
              $(v).removeClass('fa-circle-thin');
              $(v).addClass('fa-circle');
            }else{
              $(v).removeClass('fa-circle');
              $(v).addClass('fa-circle-thin');
            }
            counter++;
          });
          $input.trigger('change');
        });
        $elem.find('.' + options.submitButtonClass).click(function(e) {
          $form.submit();
        });
      });
    };
    $.fn[pluginName].defaults = defaults;
  })('keypad');
})(jQuery);